
// disable the general store secrets and ready badge tasks
function BadgeStart::onEnter()
{
   // enable the badge tasks
   TaskModifier.strMarkVertex("Badgetasks", "BadgeStart", $TSV_CMPLETE);
}

// disable the general store secrets and ready badge tasks (these are
// for general task badges-- per map)
function BadgeStartGeneral::onEnter()
{
   // disable the general store secretes
   tsEnableCommand(woolCmdData, false);
   tsEnableCommand(HoneyjarCmdData, false);
   tsEnableCommand(PumpkinpieCmdData, false);

   // enable the badge tasks
   TaskModifier.strMarkVertex("Badgetasksgeneral", "BadgeStartGeneral", $TSV_CMPLETE);
}

// HONEYPOT BADGE (general badge)
// build 10 flower pots (unlocks honey pot)
// build a honey pot (create a bear unit)

// check for ten flowerpots on the same map
function BadgeHoneypot1::onMessage(%vertex, %msg, %params)
{
   Parent::onMessage(%vertex, %msg, %params);
   if (%vertex.isMarkedComplete() == false)
   {
      return;
   }
   
   // get all of the flower pots on the map
   %list = tsCreateObjList();
   tsFindObjTypeOnMap("Flowerpot", "bldg", %list);
   
   // count the number of flower pots on the player's team
   %flowerCount = 0;
   %count = %list.getSize();
   for (%index = 0; %index < %count; %index++)
   {
      // if this object is not on the player team, skip it
      %object = %list.getID(%index);
      if (%object.getTeam() != $OST_PLAYER)
      {
         continue;
      }
      
      // if this object is producing, the flowerpot should be counted
      %building = slgQueryInterface(%object, $CID_BUILDING);
      if (%building.getState() == $BuildingState::Production)
      {
         %flowerCount++;
      }
   }
   tsDestroyObjList(%list);
   
   // if we do not have enough flowers, restart the vertex
   if (%flowerCount < 10)
   {
      // pretend that this vertex was not affected (needs to be immediately
      // resolved, so the vertex is always active to receive messages)
      %vertex.decCompleteCount();
      TaskModifier.strMarkVertex("Badgetasksgeneral", "BadgeHoneypot1", $TSV_AVAIL);
      return;
   }
   
   // notify the character that a honey pot was unlocked
   tsSendTaskClickDlg("ID_TASKNAME_HONEYPOT", "ID_Honeypot",
      $TaskButton::Okay, HeroCharacter, "ID_Honeypot");
}

// check if the honeypot should be enabled
function BadgeHoneypot2::onExit(%vertex)
{
   HoneypotButton.input = true;
   HoneypotButton.disabled = false;
   HoneypotButton.iconEnabled = "assets/client/ui/icons/honeypot.png";
}

// after a honey pot is placed, a bear appears and walks to the honey pot
function BadgeHoneypot3::onExit(%vertex)
{
   // get all honey pots currently on the map
   %list = tsCreateObjList();
   tsFindObjTypeOnMap("Honeypot", "bldg", %list);
   
   // find a honey pot to move the bear to
   %honey = 0;
   %count = %list.getSize();
   for (%index = 0; %index < %count; %index++)
   {
      // make sure this honey pot in on the player's team
      %object = %list.getID(%index);
      if (%object.getTeam() != $OST_PLAYER)
      {
         continue;
      }
      
      // make sure this honey pot is built
      %building = slgQueryInterface(%object, $CID_BUILDING);
      if (%building.getState() == $BuildingState::Production)
      {
         %honey = %object;
         break;
      }
   }
   tsDestroyObjList(%list);
   
   // create a bear and move the bear to the honey pot (only create
   // a bear for the honey pot if we are not in sandbox mode)
   if (slgUseSandbox() == false)
   {
      %position = GetSameRegionPosition(%honey, 50);
      %bear = tsCreateObj("TownBear", "Bear", $OST_NEUTRAL, %position);
      %bear.startFade(1000, 0, false);
      tsMoveObjToTarget(%bear, %honey);
   }
}

// reward the badge when the bear reaches the honey pot
function BadgeHoneypot4::onExit(%vertex)
{
   // the bear joins the player's team
   Bear.setTeam($OST_PLAYER);
   
   // reward the honeypot badge
   tsUnlockBadge("badge_honeypot");
   tsAwardBadge("badge_honeypot");
}



// 3 AMIGOS BADGE (general badge)
// hire 3 nice Gunslingers

// count the gunslingers that have been created that are nice,
// and make sure they are living (once 3 is reached, badge awarded)
function Badge3Amigos::onMessage(%vertex, %msg, %params)
{
   Parent::onMessage(%vertex, %msg, %params);
   if (%vertex.isMarkedComplete() == false)
   {
      return;
   }
   
   // get all of the nice gunslingers on the map
   %list = tsCreateObjList();
   tsFindObjTypeOnMap("Nicegunslinger", "char", %list);

   // count how many of the nice gunslingers are available
   %slingerCount = 0;
   %slingerList = "";
   %count = %list.getSize();
   for (%index = 0; %index < %count; %index++)
   {
      // if the gunslinger is not on the player's team, move on
      %object = %list.getID(%index);
      if (%object.getTeam() != $OST_PLAYER)
      {
         continue;
      }
      
      // if the gunslinger is alive, add it to the count
      if (%object.health > 0)
      {
         %slingerCount++;
         %slingerList = %slingerList @ %object.getID() @ " ";
      }
   }
   tsDestroyObjList(%list);
   
   // if we do not have enough slingers, restart the vertex
   if (%slingerCount < 3)
   {
      // pretend that this vertex was not affected (needs to be immediately
      // resolved, so the vertex is always active to receive messages)
      %vertex.decCompleteCount();
      TaskModifier.strMarkVertex("Badgetasksgeneral", "Badge3Amigos", $TSV_AVAIL);
      return;
   }
   
   // turn the three gunslingers to amigos
   for (%index = 0; %index < 3; %index++)
   {
      %object = getWord(%slingerList, %index);
      %object.mountImage(Sombrero, 0);
      %object.removeHat = false;
      %object.amigo = true;
   }
   
   // award the badge
   tsUnlockBadge("badge_3amigos");
   tsAwardBadge("badge_3amigos");
}



// CARPENTER BADGE
// build every building at least once

// when all of the required buildings have been built, award the badge
function BadgeCarpenter::onExit(%vertex)
{
   // award the carepenter badge
   tsAwardBadge("badge_carpenter");
}



// POPULATION BADGE
// reach a population of 40 civilians

// check if the population has reached 40 (award if condition met)
function BadgePopulation::onUpdate(%vertex)
{
   // check if we have enough civilians for the badge
	if (rsGetResourceCount($Resource::People) >= 40)
	{
	   // awart the badge and end the vertex
     tsAwardBadge("badge_population");
     TaskModifier.strMarkVertex("Badgetasks", "BadgePopulation", $TSV_CMPLETE);
 	}
}



// PARADISE BADGE
// maintain 120 happiness with at least 20 civilians for 3 minutes

// monitors the civilian count to ensure we have enough civlians
function BadgeParadiseCivCreate::onUpdate(%vertex)
{
   // check if we have enough civilians for the paradise requirements
	if (rsGetResourceCount($Resource::People) >= 20) 
	{
	   // start the paradise civilian monitor
      TaskModifier.strMarkVertex("Badgetasks", "BadgeParadiseCivCreate", $TSV_CMPLETE);
      TaskModifier.strResetVertex("Badgetasks", "BadgeParadiseCivDestroy");
      TaskModifier.strMarkVertex("Badgetasks", "BadgeParadiseCivDestroy", $TSV_AVAIL);
	}
}

// monitors the civilian count to see if we fall below the paradise limit
function BadgeParadiseCivDestroy::onUpdate(%vertex)
{
	// check if we do not have enough civilians paradise requirements
	if (rsGetResourceCount($Resource::People) < 20) 
	{
	   // start the paradise civilian checks
      TaskModifier.strMarkVertex("Badgetasks", "BadgeParadiseCivDestroy", $TSV_CMPLETE);
      TaskModifier.strResetVertex("Badgetasks", "BadgeParadiseCivCreate");
      TaskModifier.strMarkVertex("Badgetasks", "BadgeParadiseCivCreate", $TSV_AVAIL);
      TaskModifier.strResetVertex("Badgetasks", "BadgeParadiseTimer");
	}
}

// monitors the happiness to ensure we have enough happiness
function BadgeParadiseHappyCreate::onUpdate(%vertex)
{
   // check if we have enough happiness for the paradise requirements
	if (rsGetResourceCount($Resource::Happiness) >= 120) 
	{
	   // start the paradise happiness monitor
      TaskModifier.strMarkVertex("Badgetasks", "BadgeParadiseHappyCreate", $TSV_CMPLETE);
      TaskModifier.strResetVertex("Badgetasks", "BadgeParadiseHappyDestroy");
      TaskModifier.strMarkVertex("Badgetasks", "BadgeParadiseHappyDestroy", $TSV_AVAIL);
	}
}

// monitors the happiness to see if we fall below the paradise limit
function BadgeParadiseHappyDestroy::onUpdate(%vertex)
{
   // check if we do not have enough happiness paradise requirements
	if (rsGetResourceCount($Resource::Happiness) < 120) 
	{
	   // start the paradise happiness checks
      TaskModifier.strMarkVertex("Badgetasks", "BadgeParadiseHappyDestroy", $TSV_CMPLETE);
      TaskModifier.strResetVertex("Badgetasks", "BadgeParadiseHappyCreate");
      TaskModifier.strMarkVertex("Badgetasks", "BadgeParadiseHappyCreate", $TSV_AVAIL);
      TaskModifier.strResetVertex("Badgetasks", "BadgeParadiseTimer");
	}
}

// this fires after 3 minutes of happiness and civilian requiredments met
function BadgeParadiseTimer::onExit(%vertex)
{
   // turn off monitors
   TaskModifier.strMarkVertex("Badgetasks", "BadgeParadiseCivDestroy", $TSV_CMPLETE);
   TaskModifier.strMarkVertex("Badgetasks", "BadgeParadiseHappyDestroy", $TSV_CMPLETE);
   
   // award the badge
   tsAwardBadge("badge_paradise");
}



// GOLD BADGE
// save up to 8000 gold

// check the gold resources to see if the requirements are met
function BadgeGold::onUpdate(%vertex)
{
   // check the current gold resources
	if (rsGetResourceCount($Resource::Gold) >= 8000)
	{
	   // award the badge and close the vertex
	   tsAwardBadge("badge_gold");
      TaskModifier.strMarkVertex("Badgetasks", "BadgeGold", $TSV_CMPLETE);
 	}
}



// HUB BADGE
// complete all three outpost quests

// check if the outpost tasks are complete
function BadgeHubMissions::onUpdate(%vertex)
{
   // if the outpost tasks are complete, enable the final vertex
   if (OutpostTaskFoodComplete.isComplete() == true &&
      OutpostTaskWoodComplete.isComplete() == true &&
      OutpostTaskGoldComplete.isComplete() == true)
   {
      TaskModifier.strMarkVertex("Badgetasks", "BadgeHubMissions", $TSV_CMPLETE);
   }
}

// when all of the outpost quests are complete and a train station is built
function BadgeHubComplete::onEnter(%vertex)
{
   
   // award the hub badge
   tsAwardBadge("badge_hub");
   TaskModifier.strMarkVertex("Badgetasks", "BadgeHubComplete", $TSV_CMPLETE);
}



// TREASURE BADGE
// complete both main map treasure quests

// if the first treasure quest is complete, unlock the badge
function BadgeTreasure1::onExit(%vertex)
{
   // unlock the treasure badge
   tsUnlockBadge("badge_treasure");
}

// if the second treasure quest is complete, unlock the badge
function BadgeTreasure2::onExit(%vertex)
{
   // unlock the treasure badge
   tsUnlockBadge("badge_treasure");
}

// if both treasure quests are complete, award the badge
function BadgeTreasureComplete::onEnter(%vertex)
{
   // award the badge
   tsAwardBadge("badge_treasure");
   
   // kill the treasure vertex
   TaskModifier.strMarkVertex("Badgetasks", "BadgeTreasureComplete", $TSV_CMPLETE);
}



// PIONEER BADGE
// beat the game with a single hero

// if you beat the game with the farmer
function BadgePioneer1::onExit(%vertex)
{
   // award the pioneer badge
   tsAwardBadge("badge_pioneer1");
}

// if you beat the game with the banker
function BadgePioneer2::onExit(%vertex)
{
   // award the pioneer badge
   tsAwardBadge("badge_pioneer1");
}

// if you beat the game with the hunter
function BadgePioneer3::onExit(%vertex)
{
   // award the pioneer badge
   tsAwardBadge("badge_pioneer1");
}



// MASTER PIONEER BADGE
// beat the game with all three heroes

// when all three heroes have beaten the game
function BadgeMasterPioneer::onEnter(%vertex)
{
   // award the badge
   tsAwardBadge("badge_pioneer3");
   
   // kill the master pioneer vertex
   //TaskModifier.strMarkVertex("Badgetasks", "BadgeMasterPioneer", $TSV_CMPLETE);
}



// MAYOR BADGE
// hire a mayor

function BadgeMayor::onExit(%vertex)
{
   // award the badge
   tsAwardBadge("badge_mayor");
}



// BANDIT BADGE
// defeat 50 bandits

// a male bandit is destroyed
function BadgeBanditMale::onMessage(%vertex, %msg, %params)
{
   // if the target object is not dead, to not process the message
   // (only bandits that die should be processed)
   %list = tsGetObjListFromMsg(%msg, %params);
   %count = %list.getSize();
   for (%index = 0; %index < %count; %index++)
   {
      // check this object that the message is processing on, and
      // if it has health left, it did not die
      %object = %list.getId(%index);
      if (%object.health > 0)
      {
         return;
      }
   }
   
   // handle a potential bandit getting destroyed
   Parent::onMessage(%vertex, %msg, %params);
   
   %totalCnt = %vertex.getCompleteCount();
   %currCntmale = %vertex.getCurrentCompleteCount();
   %currCntfemale = BadgeBanditFemale.getCurrentCompleteCount();
   %currCnt = %currCntfemale+%currCntmale;
   
   // if count is met, award the badge
   if (%totalCnt <= %currCnt) 
   {
      tsAwardBadge("badge_bandit");
      TaskModifier.strMarkVertex("Badgetasks", "BadgeBanditFemale", $TSV_CMPLETE);
      TaskModifier.strMarkVertex("Badgetasks", "BadgeBanditMale", $TSV_CMPLETE);
   }
}

// a female bandit is destroyed
function BadgeBanditFemale::onMessage(%vertex, %msg, %params)
{
   // if the target object is not dead, to not process the message
   // (only bandits that die should be processed)
   %list = tsGetObjListFromMsg(%msg, %params);
   %count = %list.getSize();
   for (%index = 0; %index < %count; %index++)
   {
      // check this object that the message is processing on, and
      // if it has health left, it did not die
      %object = %list.getId(%index);
      if (%object.health > 0)
      {
         return;
      }
   }
   
   // handle a potential bandit getting destroyed
   Parent::onMessage(%vertex, %msg, %params);
   
   %totalCnt = %vertex.getCompleteCount();
   %currCntfemale = %vertex.getCurrentCompleteCount();
   %currCntfemale = %vertex.getCurrentCompleteCount();
   %currCntmale = BadgeBanditMale.getCurrentCompleteCount();
   %currCnt = %currCntfemale+%currCntmale;
   
   // if count is met, award the badge
   if (%totalCnt <= %currCnt) 
   {
      tsAwardBadge("badge_bandit");
      TaskModifier.strMarkVertex("Badgetasks", "BadgeBanditFemale", $TSV_CMPLETE);
      TaskModifier.strMarkVertex("Badgetasks", "BadgeBanditMale", $TSV_CMPLETE);
   }
}



// HAPPY BADGE
// reach 200 happiness

// check the happiness
function BadgeHappy::onUpdate(%vertex)
{
   // check if the happiness limit has been reached
	if (rsGetResourceCount($Resource::Happiness) >= 200)
	{
	   // award the badge
     tsAwardBadge("badge_happy");
     
     // end the task
     TaskModifier.strMarkVertex("Badgetasks", "BadgeHappy", $TSV_CMPLETE);
 	}
}



// CITY BADGE
// build a town with 30 buildings

// every time an object is created on the player's team, look for all
// buidlings that are producting on the players team for the award
function BadgeCity::onMessage(%vertex, %msg, %params)
{
   // if an object was not created on this team, do nothing
   Parent::onMessage(%vertex, %msg, %params);
   if (%vertex.isMarkedComplete() == false)
   {
      return;
   }
   
   // count the number of buildings that are on the player's team
   // and are in the production state
   %buildingCount = 0;
   %list = slgGetServerBuildingList();
   %count = %list.getSize();
   for (%index = 0; %index < %count; %index++)
   {
      // make sure the building is on the player's team
      %object = %list.getId(%index);
      if (%object.getTeam() != $OST_PLAYER)
      {
         continue;
      }
      
      // only count town buildings
      if (%object.isTownBuilding() == false)
      {
         continue;
      }
      
      // make sure the building is in the production state
      %building = slgQueryInterface(%object, $CID_BUILDING);
      if (%building.getState() == $BuildingState::Production)
      {
         %buildingCount++;
      }
   }
   
   // if there are not enough player buildings do nothing
   if (%buildingCount < 30)
   {
      // pretend that this vertex was not affected (needs to be immediately
      // resolved, so the vertex is always active to receive messages)
      %vertex.decCompleteCount();
      TaskModifier.strMarkVertex("BadgeTasks", "BadgeCity", $TSV_AVAIL);
      return;
   }
   
   // we have enough buildings, so award the badge
   tsAwardBadge("badge_city");
}



// FOOD BADGE
// store up to 150 food

// check the food count
function BadgeFood::onUpdate(%vertex)
{
	if (rsGetResourceCount($Resource::Food) >= 150)
	{
	   // award the badge
     tsAwardBadge("badge_food");
     
     // end the task
     TaskModifier.strMarkVertex("Badgetasks", "BadgeFood", $TSV_CMPLETE);
 	}
}



// EXPERIENCE BADGE
// purchase all experience items from the shop

// when the badge starts, enable hero states, so things can be unlocked
function BadgeExperience::onEnter(%vertex)
{
   // activate the hero stats, now
   slgActivateTask("Herostats");
   TaskModifier.strMarkVertex("Herostats", "Herocheck", $TSV_AVAIL);
}

// after all of the items have been purchased
function BadgeExperience::onExit(%vertex)
{
   tsAwardBadge("badge_experience");
}



// SHERIFF BADGE
// hire a sheriff

// check if the nice sheriff is hired
function BadgeSheriff1::onExit(%vertex)
{
   // award the badge
   tsAwardBadge("badge_sheriff");
}

// check if the tough sheriff is hired
function BadgeSheriff2::onExit(%vertex)
{
   // award the badge
   tsAwardBadge("badge_sheriff");
}
